package org.msh.tb.medicines.movs;

import org.msh.tb.entities.Batch;


/**
 * MovementException is the exception generated by the MovementHome class when including or removing
 * medicine movements in a unit stock. If any error with stock management (like invalid dates or 
 * trying to decrease more than it's available, for example) the system will generate this exception
 * with a message attached to it
 * @author Ricardo Memoria
 *
 */
public class MovementException extends RuntimeException {
	private static final long serialVersionUID = -3937803767842122125L;

	private Batch batch;
	
	public MovementException(Batch batch, String msg) {
		super(msg);
		this.batch = batch;
	}
	
	public MovementException(String msg) {
		super(msg);
	}
	
	public Batch getBatch() {
		return batch;
	}
}
